function [image,Original]=SwitchGainRef(handles,OldRef,NewRef)

WaitTics   = 3;
WaitTotal  = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
%% Get handles
image      = load(fullfile(tempdir,'ShowOrg.mat')).image;
Original   = load(fullfile(tempdir,'Original.mat')).image;
WaitTotal.Send;
Cut        = get(handles.EstimateRho,'UserData');
if ~isempty(Cut)
    Cut1       = Cut(1);
    Cut2       = Cut(2);
end
Drift      = get(handles.ShowDrift,'UserData');
EnergyRes  = get(handles.Slider, 'SliderStep');
EnergyRes  = EnergyRes(1);

%% Correct Original Image

OldRefOrg  = repmat(OldRef,[size(Original,1),size(Original,2),1]);
NewRefOrg  = repmat(NewRef,[size(Original,1),size(Original,2),1]);
Original   = Original .* OldRefOrg ./ NewRefOrg;
WaitTotal.Send;

%% Correct Aligned Image
Drift      =  round(Drift./EnergyRes);

if ~isempty(Drift)
    WaitTics   = size(image,1);
    WaitFrame  = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
    OldRef     = repmat(OldRef,[size(image,1),size(image,2),1]);
    NewRef     = repmat(NewRef,[size(image,1),size(image,2),1]);
    
    for i=1:size(image,1)
        for j=1:size(image,2)
            OldRef(i,j,:) = circshift(OldRef(i,j,:),-Drift(i,j),3);
            NewRef(i,j,:) = circshift(NewRef(i,j,:),-Drift(i,j),3);
        end
        WaitFrame.Send;
    end
    WaitFrame.Destroy;
    OldRef = OldRef(:,:,1+Cut1:end-Cut2);
    NewRef = NewRef(:,:,1+Cut1:end-Cut2);
    
    image = image .* OldRef ./ NewRef;
else
    image = Original;
end
WaitTotal.Send;
WaitTotal.Destroy;
clearvars -except image Original
end
